/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class CMSDocument extends DJDocument {
	
	private static final String FIELD_ACTIVE = "F_isactive";
	private static final String FIELD_TITEL = "F_titel";
	
	public static CMSDocument getInstance (Document initialDoc) {
		if (initialDoc==null) {
			return null;
		} else {
			return new CMSDocument (initialDoc);
		}
	}
	public boolean isActive () throws NotesException {
		if (this.hasItem(FIELD_ACTIVE)) {
			return this.getItemValueInteger(FIELD_ACTIVE) == 1;
		} else {
			return false;
		}
	}
	public void setActive (boolean flag) throws NotesException {
		this.replaceItemValue (FIELD_ACTIVE,new Integer (flag?1:0));
	}
	public String getTitle () throws NotesException {
		return this.getItemValueString(FIELD_TITEL);
	}
	public Item setTitle (String t) throws NotesException {
		return this.replaceItemValue(FIELD_TITEL, t);
	}	
	private CMSDocument (Document doc) {
		//this is private -> please use getInstance
		super (doc);
	}
}